
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class Instructor : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.Instructor, BO.Instructor>
    {

        internal Instructor(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Instructor(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.Instructor.DBD) { }

        internal List<BO.Instructor> Restore(BO.Instructor.Search Search)
        {            
            return InternalRestoreList((int)DBD.Instructor.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["Forename"].Value = Search.Forename;
                Command["Surename"].Value = Search.Surename;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["UserID"].Value = Search.UserID;
                Command["Email"].Value = Search.Email;
            });
        }

        internal BO.Instructor RestoreTopOne(BO.Instructor.Search Search)
        {
            return InternalRestoreOne((int)DBD.Instructor.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["Forename"].Value = Search.Forename;
                Command["Surename"].Value = Search.Surename;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["UserID"].Value = Search.UserID;
                Command["Email"].Value = Search.Email;
            });
        }
    }
}